<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database configuration
$dbHost = 'localhost';
$dbName = 'gabnsonq_yashappm_admin';
$dbUser = 'gabnsonq_yashadmin';
$dbPass = 'Webview@2025';

// API Key for authentication
$validApiKey = 'Webview@2025';

// Handle preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

// Get the request method
$method = $_SERVER['REQUEST_METHOD'];

// Get the authorization header
$headers = getallheaders();
$authHeader = $headers['Authorization'] ?? '';

// Extract the token from the Authorization header
$token = '';
if (preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
    $token = $matches[1];
}

// Verify API key
if ($token !== $validApiKey) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

try {
    // Create database connection
    $pdo = new PDO("mysql:host=$dbHost;dbname=$dbName;charset=utf8mb4", $dbUser, $dbPass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);

    // Create tables if they don't exist
    $pdo->exec("CREATE TABLE IF NOT EXISTS analytics_events (
        id INT AUTO_INCREMENT PRIMARY KEY,
        event_type VARCHAR(50) NOT NULL,
        item_id VARCHAR(100),
        item_title VARCHAR(255),
        url TEXT,
        device_info TEXT,
        app_version VARCHAR(50),
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        INDEX idx_event_type (event_type),
        INDEX idx_item_id (item_id),
        INDEX idx_created_at (created_at)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");

    // Handle POST request to record an event
    if ($method === 'POST' && $_SERVER['REQUEST_URI'] === '/api/analytics') {
        $input = json_decode(file_get_contents('php://input'), true);
        
        // Validate input
        if (!isset($input['event_type'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing required field: event_type']);
            exit();
        }
        
        // Prepare the insert statement
        $stmt = $pdo->prepare("INSERT INTO analytics_events 
            (event_type, item_id, item_title, url, device_info, app_version) 
            VALUES (:event_type, :item_id, :item_title, :url, :device_info, :app_version)");
        
        // Bind parameters
        $stmt->bindValue(':event_type', $input['event_type']);
        $stmt->bindValue(':item_id', $input['item_id'] ?? null);
        $stmt->bindValue(':item_title', $input['item_title'] ?? null);
        $stmt->bindValue(':url', $input['url'] ?? null);
        $stmt->bindValue(':device_info', isset($input['device_info']) ? json_encode($input['device_info']) : null);
        $stmt->bindValue(':app_version', $input['app_version'] ?? null);
        
        // Execute the statement
        $stmt->execute();
        
        // Return success response
        http_response_code(201);
        echo json_encode(['success' => true, 'id' => $pdo->lastInsertId()]);
    } 
    // Handle GET request to get analytics data
    elseif ($method === 'GET' && strpos($_SERVER['REQUEST_URI'], '/api/analytics/summary') === 0) {
        // Get date range from query parameters (default to last 30 days)
        $startDate = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
        $endDate = $_GET['end_date'] ?? date('Y-m-d');
        
        // Get summary data
        $summary = [];
        
        // Total events
        $stmt = $pdo->prepare("SELECT COUNT(*) as total_events FROM analytics_events WHERE DATE(created_at) BETWEEN :start_date AND :end_date");
        $stmt->execute([':start_date' => $startDate, ':end_date' => $endDate]);
        $summary['total_events'] = $stmt->fetch()['total_events'];
        
        // Events by type
        $stmt = $pdo->prepare("SELECT event_type, COUNT(*) as count 
                              FROM analytics_events 
                              WHERE DATE(created_at) BETWEEN :start_date AND :end_date 
                              GROUP BY event_type 
                              ORDER BY count DESC");
        $stmt->execute([':start_date' => $startDate, ':end_date' => $endDate]);
        $summary['events_by_type'] = $stmt->fetchAll();
        
        // Top items by views
        $stmt = $pdo->prepare("SELECT item_id, item_title, COUNT(*) as views 
                              FROM analytics_events 
                              WHERE event_type = 'card_view' 
                              AND DATE(created_at) BETWEEN :start_date AND :end_date 
                              GROUP BY item_id, item_title 
                              ORDER BY views DESC 
                              LIMIT 10");
        $stmt->execute([':start_date' => $startDate, ':end_date' => $endDate]);
        $summary['top_items'] = $stmt->fetchAll();
        
        // Daily active users (approximate)
        $stmt = $pdo->prepare("SELECT DATE(created_at) as date, COUNT(DISTINCT device_info) as active_users 
                              FROM analytics_events 
                              WHERE DATE(created_at) BETWEEN :start_date AND :end_date 
                              GROUP BY DATE(created_at) 
                              ORDER BY date");
        $stmt->execute([':start_date' => $startDate, ':end_date' => $endDate]);
        $summary['daily_active_users'] = $stmt->fetchAll();
        
        // Return the summary data
        echo json_encode($summary);
    }
    // Handle GET request to get detailed analytics
    elseif ($method === 'GET' && strpos($_SERVER['REQUEST_URI'], '/api/analytics/events') === 0) {
        // Get pagination and filter parameters
        $page = max(1, intval($_GET['page'] ?? 1));
        $limit = min(100, max(1, intval($_GET['limit'] ?? 20)));
        $offset = ($page - 1) * $limit;
        
        $where = [];
        $params = [];
        
        // Add filters
        if (isset($_GET['event_type'])) {
            $where[] = 'event_type = :event_type';
            $params[':event_type'] = $_GET['event_type'];
        }
        
        if (isset($_GET['item_id'])) {
            $where[] = 'item_id = :item_id';
            $params[':item_id'] = $_GET['item_id'];
        }
        
        if (isset($_GET['start_date'])) {
            $where[] = 'DATE(created_at) >= :start_date';
            $params[':start_date'] = $_GET['start_date'];
        }
        
        if (isset($_GET['end_date'])) {
            $where[] = 'DATE(created_at) <= :end_date';
            $params[':end_date'] = $_GET['end_date'];
        }
        
        // Build the WHERE clause
        $whereClause = $where ? 'WHERE ' . implode(' AND ', $where) : '';
        
        // Get total count for pagination
        $countStmt = $pdo->prepare("SELECT COUNT(*) as total FROM analytics_events $whereClause");
        $countStmt->execute($params);
        $total = $countStmt->fetch()['total'];
        
        // Get paginated results
        $stmt = $pdo->prepare("SELECT * FROM analytics_events $whereClause ORDER BY created_at DESC LIMIT :limit OFFSET :offset");
        
        // Bind parameters
        foreach ($params as $key => $value) {
            $stmt->bindValue($key, $value);
        }
        $stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
        $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
        
        $stmt->execute();
        $events = $stmt->fetchAll();
        
        // Parse device info
        foreach ($events as &$event) {
            if ($event['device_info']) {
                $event['device_info'] = json_decode($event['device_info'], true);
            }
        }
        
        // Return paginated results
        echo json_encode([
            'total' => (int)$total,
            'page' => $page,
            'limit' => $limit,
            'total_pages' => ceil($total / $limit),
            'data' => $events
        ]);
    }
    // Handle invalid endpoints
    else {
        http_response_code(404);
        echo json_encode(['error' => 'Not found']);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error: ' . $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
