<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config.php';

try {
    $pdo = getDBConnection();
    
    // Get the current active URL
    $stmt = $pdo->prepare("SELECT * FROM webview_urls WHERE is_active = TRUE ORDER BY updated_at DESC LIMIT 1");
    $stmt->execute();
    $url = $stmt->fetch();
    
    if ($url) {
        echo json_encode([
            'success' => true,
            'url' => $url['url'],
            'title' => $url['title'],
            'description' => $url['description'],
            'updated_at' => $url['updated_at']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'No active URL found',
            'url' => 'https://www.google.com' // Fallback URL
        ]);
    }
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
        'url' => 'https://www.google.com' // Fallback URL
    ]);
}
?> 