<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Set headers
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

try {
    // Include database configuration
    require_once __DIR__ . '/../config.php';
    
    // Get database connection
    $pdo = getDBConnection();
    
    // Get all active webview URLs
    $stmt = $pdo->query("
        SELECT 
            id,
            url,
            title,
            description,
            thumbnail_url, -- ✅ New column
            created_at AS createdAt,
            updated_at AS updatedAt
        FROM webview_urls 
        WHERE is_active = TRUE
        ORDER BY updated_at DESC
    ");
    
    $activeUrls = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Return JSON response
    echo json_encode([
        'success' => true,
        'data' => $activeUrls
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    // Return error response
    http_response_code(500);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ], JSON_PRETTY_PRINT);
}
