-- Create database
CREATE DATABASE IF NOT EXISTS webview_app;
USE webview_app;

-- Table for storing admin users
CREATE TABLE IF NOT EXISTS `admins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Table for storing webview URLs
CREATE TABLE IF NOT EXISTS `webview_urls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(1000) NOT NULL,
  `title` varchar(255) DEFAULT 'Website',
  `description` text DEFAULT NULL,
  `thumbnail_url` varchar(1000) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_is_active` (`is_active`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default admin (username: admin, password: admin123 - change this after first login)
INSERT IGNORE INTO `admins` (`username`, `password`) 
VALUES ('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi');

-- Insert default URLs
INSERT IGNORE INTO `webview_urls` 
(`url`, `title`, `description`, `is_active`) 
VALUES 
('https://www.google.com', 'Google', 'Search Engine', 1),
('https://yashapp.me', 'YashApp', 'Default WebView URL', 1),
('https://github.com', 'GitHub', 'Code Hosting Platform', 1);

-- Update any existing records to match the new schema
UPDATE `webview_urls` SET 
  `title` = CASE 
    WHEN `url` LIKE '%google%' THEN 'Google'
    WHEN `url` LIKE '%yashapp%' THEN 'YashApp'
    WHEN `url` LIKE '%github%' THEN 'GitHub'
    ELSE 'Website'
  END,
  `description` = CASE
    WHEN `url` LIKE '%google%' THEN 'Search Engine'
    WHEN `url` LIKE '%yashapp%' THEN 'Default WebView URL'
    WHEN `url` LIKE '%github%' THEN 'Code Hosting Platform'
    ELSE 'Website'
  END
WHERE `title` IS NULL OR `description` IS NULL;