<?php
// Test script for API endpoints
// Run this in your browser to test the API

echo "<h1>WebView API Test</h1>";

// Test database connection
echo "<h2>1. Database Connection Test</h2>";
try {
    require_once 'config.php';
    $pdo = getDBConnection();
    echo "<p style='color: green;'>✓ Database connection successful</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Database connection failed: " . $e->getMessage() . "</p>";
    exit;
}

// Test get_url.php
echo "<h2>2. Get URL API Test</h2>";
$api_url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/api/get_url.php';
echo "<p>Testing: <code>$api_url</code></p>";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code === 200) {
    $data = json_decode($response, true);
    if ($data && isset($data['success'])) {
        echo "<p style='color: green;'>✓ Get URL API working</p>";
        echo "<p><strong>Current URL:</strong> " . htmlspecialchars($data['url']) . "</p>";
        if (isset($data['title'])) {
            echo "<p><strong>Title:</strong> " . htmlspecialchars($data['title']) . "</p>";
        }
    } else {
        echo "<p style='color: red;'>✗ Invalid JSON response</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
    }
} else {
    echo "<p style='color: red;'>✗ HTTP Error: $http_code</p>";
    echo "<pre>" . htmlspecialchars($response) . "</pre>";
}

// Test update_url.php
echo "<h2>3. Update URL API Test</h2>";
$update_url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/api/update_url.php';
echo "<p>Testing: <code>$update_url</code></p>";

$test_data = json_encode([
    'url' => 'https://www.example.com',
    'title' => 'Test Website',
    'description' => 'This is a test update'
]);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $update_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $test_data);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($test_data)
]);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code === 200) {
    $data = json_decode($response, true);
    if ($data && isset($data['success'])) {
        echo "<p style='color: green;'>✓ Update URL API working</p>";
        echo "<p><strong>Response:</strong> " . htmlspecialchars($data['message']) . "</p>";
    } else {
        echo "<p style='color: red;'>✗ Invalid JSON response</p>";
        echo "<pre>" . htmlspecialchars($response) . "</pre>";
    }
} else {
    echo "<p style='color: red;'>✗ HTTP Error: $http_code</p>";
    echo "<pre>" . htmlspecialchars($response) . "</pre>";
}

// Test admin panel access
echo "<h2>4. Admin Panel Test</h2>";
$admin_url = 'http://' . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/login.php';
echo "<p>Admin Panel: <a href='$admin_url' target='_blank'>$admin_url</a></p>";
echo "<p><strong>Default credentials:</strong> admin / admin123</p>";

// Display current database content
echo "<h2>5. Current Database Content</h2>";
try {
    $stmt = $pdo->prepare("SELECT * FROM webview_urls ORDER BY updated_at DESC LIMIT 5");
    $stmt->execute();
    $urls = $stmt->fetchAll();
    
    if ($urls) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>URL</th><th>Title</th><th>Active</th><th>Updated</th></tr>";
        foreach ($urls as $url) {
            echo "<tr>";
            echo "<td>" . $url['id'] . "</td>";
            echo "<td>" . htmlspecialchars($url['url']) . "</td>";
            echo "<td>" . htmlspecialchars($url['title']) . "</td>";
            echo "<td>" . ($url['is_active'] ? 'Yes' : 'No') . "</td>";
            echo "<td>" . $url['updated_at'] . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>No URLs found in database</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Error reading database: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><strong>Test completed!</strong> If all tests pass, your API is ready for the Flutter app.</p>";
?> 