<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

require_once '../config.php';

// Only allow POST requests
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'success' => false,
        'message' => 'Only POST requests are allowed'
    ]);
    exit;
}

// Get JSON input
$input = json_decode(file_get_contents('php://input'), true);

if (!$input) {
    echo json_encode([
        'success' => false,
        'message' => 'Invalid JSON input'
    ]);
    exit;
}

$url = $input['url'] ?? '';
$title = $input['title'] ?? '';
$description = $input['description'] ?? '';

if (empty($url)) {
    echo json_encode([
        'success' => false,
        'message' => 'URL is required'
    ]);
    exit;
}

try {
    $pdo = getDBConnection();
    
    // Update the active URL
    $stmt = $pdo->prepare("UPDATE webview_urls SET is_active = FALSE");
    $stmt->execute();
    
    $stmt = $pdo->prepare("INSERT INTO webview_urls (url, title, description, is_active) VALUES (?, ?, ?, TRUE)");
    $stmt->execute([$url, $title, $description]);
    
    echo json_encode([
        'success' => true,
        'message' => 'URL updated successfully',
        'url' => $url,
        'title' => $title,
        'description' => $description
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}
?> 